const swiper = new Swiper(".swiper", {
	// If we need pagination
	pagination: {
		el: ".swiper-pagination",
	},

	// Navigation arrows

	// navigation: {
	//   nextEl: '.swiper-button-next',
	//   prevEl: '.swiper-button-prev',
	// },

	scrollbar: {
		el: ".swiper-scrollbar",
		draggable: true,
	},
});

document.addEventListener("DOMContentLoaded", () => {
	const menuBtn = document.querySelector("#menu-btn");
	const closeBtn = document.querySelector("#close-btn");
	const menu = document.querySelector("nav .container ul");

	//show menu
	menuBtn.addEventListener("click", () => {
		menu.style.display = "block";
		menuBtn.style.display = "none";
		closeBtn.style.display = "inline-block";
	});

	//hide menu
	closeBtn.addEventListener("click", () => {
		menu.style.display = "none";
		menuBtn.style.display = "inline-block";
		closeBtn.style.display = "none";
	});

	const navItems = menu.querySelectorAll("li");

	const changeActiveItem = () => {
		navItems.forEach((item) => {
			const link = item.querySelector("a");
			link.classList.remove("active");
		});
	};

	navItems.forEach((item) => {
		const link = item.querySelector("a");

		link.addEventListener("click", () => {
			changeActiveItem();
			link.classList.add("active");
		});
	});

	//read more or less in about section

	const readMoreBtn = document.querySelector(".read-more");
	const readMoreContent = document.querySelector(".read-more-content");

	readMoreBtn.addEventListener("click", () => {
		readMoreContent.classList.toggle("show-content");

		if (readMoreContent.classList.contains("show-content")) {
			readMoreBtn.textContent = "show less";
		} else {
			readMoreBtn.textContent = "show more";
		}
	});

	//show/hide skills items
	const skillItems = document.querySelectorAll(
		"section.skills .container .skill"
	);

	skillItems.forEach((skill) => {
		console.log(skill);
		const head = skill.querySelector(".head");
		head.querySelector(".right").addEventListener("click", () => {
			skill.querySelector(".items").classList.toggle("show-items");
		});
	});


	//add box shadow on navbar when scroll down
	window.addEventListener("scroll", () => {
		document
			.querySelector("nav")
			.classList.toggle("show-box-shadow", window.scrollY > 0);
	});



});


document.addEventListener("DOMContentLoaded", () => {
	const targets = document.querySelectorAll(".animate-left");
  
	const observer = new IntersectionObserver(
	  (entries) => {
		entries.forEach((entry) => {
		  if (entry.isIntersecting) {
			entry.target.classList.add("in-view");
		  } else {
			entry.target.classList.remove("in-view"); // Reset animation when out of view
		  }
		});
	  },
	  { threshold: 0.1 } // Trigger when 10% of the element is visible
	);
  
	targets.forEach((target) => observer.observe(target));
  });
  